// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_detected_callback( %d )", i );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_removed_callback( %d )", i );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = nVideoHeight;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %d, %d, %d )", i, nVideoWidth, nVideoHeight, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	if( i == 0 ) {

		EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

		if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

			QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
		}
		LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );
	}
    return (QRETURN)(QCAP_RT_SKIP_DISPLAY | QCAP_RT_SKIP_CLONE_DISPLAY);
}

QRETURN on_video_share_record_media_timer_callback( UINT iRecNum, double dSampleTime, double dDelayTime, PVOID pUserData  )
{
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

		UINT   iFrameNum = 0;

		BYTE * pClipFrameBuffer = NULL;

		ULONG  nClipFrameBufferLen = 0;

		QCAP_STEP_ANIMATION_CLIP( g_pAnimationFactoryDlg->m_pClip, &iFrameNum, &pClipFrameBuffer, &nClipFrameBufferLen );

		if( pClipFrameBuffer ) {

			QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, g_pAnimationFactoryDlg->m_nClipColorSpaceType, 
				
																 g_pAnimationFactoryDlg->m_nClipWidth, 
																 
																 g_pAnimationFactoryDlg->m_nClipHeight, 
																 
																 pClipFrameBuffer, 
																 
																 nClipFrameBufferLen );
		}
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	return QCAP_RT_OK;
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)
	DDX_Control(pDX, IDC_EDIT_FILE_PATH, m_editFilePath);
	DDX_Control(pDX, IDC_STATIC_SHARE_WINDOW, m_statShareWindow);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_3, m_statChannelWindow3);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_2, m_statChannelWindow2);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_1, m_statChannelWindow1);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_0, m_statChannelWindow0);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BUTTON_START, OnButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	ON_BN_CLICKED(IDC_BUTTON_FILE_OPEN, OnButtonFileOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	
	// STOP SHARE RECORDING
	//
	OnButtonStop();

	// UNINITIALIZE DEVICE RESOURCE
	// 
	for( ULONG i = 0 ; i < 4 ; i++ ) {

		if( m_pDevices[ i ] ) {

			QCAP_STOP( m_pDevices[ i ] );

			QCAP_DESTROY( m_pDevices[ i ] );

			m_pDevices[ i ] = NULL;
		}
	}
	DeleteCriticalSection( &m_hShareRecordAccessCriticalSection );

	CString strFilePath;

	m_editFilePath.GetWindowText( strFilePath );

	theApp.WriteProfileString( "DEFAULT", "FILE.PATH", (LPCTSTR)(strFilePath) );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	for( ULONG i = 0 ; i < 4 ; i++ ) {
		
		m_pDevices[ i ] = NULL;

		m_nDeviceVideoWidths[ i ] = 0;

		m_nDeviceVideoHeights[ i ] = 0;

		m_nDeviceAudioChannels[ i ] = 0;

		m_nDeviceAudioBitsPerSamples[ i ] = 0;

		m_nDeviceAudioSampleFrequencys[ i ] = 0;
	}
	m_pClip = NULL;

	m_nClipFrames = 0;

	m_nClipSprites = 0;

	m_nClipColorSpaceType = 0x00000000;

	m_nClipWidth = 0;

	m_nClipHeight = 0;

	m_nShareRecordState = 0x00000000;

	m_editFilePath.SetWindowText( theApp.GetProfileString( "DEFAULT", "FILE.PATH", "" ) );	

	InitializeCriticalSection( &m_hShareRecordAccessCriticalSection );

	// INITIALIZE DEVICE RESOURCE
	// 
	QCAP_CREATE( "FH8735 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE );

	QCAP_CREATE( "FH8735 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE );

	QCAP_CREATE( "FH8735 PCI", 2, m_statChannelWindow2.m_hWnd, &m_pDevices[ 2 ], TRUE );

	QCAP_CREATE( "FH8735 PCI", 3, m_statChannelWindow3.m_hWnd, &m_pDevices[ 3 ], TRUE );

	for( i = 0 ; i < 4 ; i++ ) {

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ i ], on_format_changed_callback, (PVOID)(i) );

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ i ], on_no_signal_detected_callback, (PVOID)(i) );

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ i ], on_no_signal_removed_callback, (PVOID)(i) );

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ i ], on_video_preview_callback, (PVOID)(i) );

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ i ], on_audio_preview_callback, (PVOID)(i) );

		QCAP_RUN( m_pDevices[ i ] );
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


void CAnimationFactoryDlg::OnButtonStart() 
{
	// TODO: Add your control notification handler code here
	// TODO: Add your control notification handler code here
	
	CString strFilePath;

	m_editFilePath.GetWindowText( strFilePath );

	if( strFilePath.IsEmpty() ) { return ; }

	OnButtonStop();

	// INITIALIZE ANIMATION RESOURCE
	// 
	QCAP_CREATE_ANIMATION_CLIP( (CHAR *)(LPCSTR)(strFilePath), &m_pClip, &m_nClipFrames, &m_nClipSprites, &m_nClipColorSpaceType, &m_nClipWidth, &m_nClipHeight );

	if( m_pClip ) {

		QCAP_START_ANIMATION_CLIP( m_pClip );

	//	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX( m_pClip, 0, m_pDevices[ 0 ], 0, 0, 960, 1080 );

		QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 0, m_pDevices[ 0 ] );

		QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 1, m_pDevices[ 1 ] );

		QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 2, m_pDevices[ 2 ] );

		QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 3, m_pDevices[ 3 ] );
	}
	else {

		return ;
	}

	// INITIALIZE SHARE RECORDING RESOURCE
	// 
	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, m_nClipColorSpaceType, m_nClipWidth, m_nClipHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, m_statShareWindow.m_hWnd, TRUE, FALSE );

	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nDeviceAudioChannels[ 0 ], m_nDeviceAudioBitsPerSamples[ 0 ], m_nDeviceAudioSampleFrequencys[ 0 ] );

	QCAP_SET_OSD_SHARE_RECORD_TEXT( 0, 0, 0, 0, 0, 0, "Yuan's Animation Clip Demo", "Arial", QCAP_FONT_STYLE_BOLD, 24, 0xFFFFFFFF, 0xFFFF0000, 0xFF );

	QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( 0, on_video_share_record_media_timer_callback, (PVOID)0);

	QCAP_START_SHARE_RECORD( 0, "DEMO.MP4", QCAP_RECORD_FLAG_DISPLAY | QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER | QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER);

	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

	m_nShareRecordState = 0x00000001;

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

	GetDlgItem( IDC_BUTTON_START )->EnableWindow( FALSE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( TRUE );
}

void CAnimationFactoryDlg::OnButtonStop() 
{
	// UNINITIALIZE SHARE RECORDING
	//
	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

	m_nShareRecordState = 0x00000000;

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

	QCAP_STOP_SHARE_RECORD( 0 );

	// UNINITIALIZE ANIMATION CLIP
	//
	if( m_pClip ) {

		QCAP_STOP_ANIMATION_CLIP( m_pClip );

		QCAP_DESTROY_ANIMATION_CLIP( m_pClip );

		m_pClip = NULL;
	}
	GetDlgItem( IDC_BUTTON_START )->EnableWindow( TRUE );

	GetDlgItem( IDC_BUTTON_STOP )->EnableWindow( FALSE );
}

void CAnimationFactoryDlg::OnButtonFileOpen() 
{
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "XML\0*.XML\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_editFilePath.SetWindowText( psz );

		SC_DEBUG( psz );

		OnButtonStop();
	}
	else {

		return ;
	}
}
